//---------------------------------------------------------------------------
#ifndef MServerThreadH
#define MServerThreadH
//---------------------------------------------------------------------------
#include<ScktComp.hpp>


typedef struct { double long x, y; } Complex;

Complex complexSquare (Complex c)
{
  Complex cSq;
  cSq.x = ( (c.x * c.x) - (c.y * c.y) );
  cSq.y = 2 * c.x * c.y;

  return(cSq);
}


class PACKAGE TMServerThread : public Scktcomp::TServerClientThread
{
  public:
    void _fastcall ClientExecute(void);
    _fastcall TMServerThread(bool CreateSuspended, TServerClientWinSocket* ASocket);
    int WorkDone; 
  private:
    unsigned char iterate(Complex z, int maxIter);
    void Mandelbrot(int sx, int sy,int ex, int ey,
                    int maxIter, double long realMin,
                    double long realMax, double long imagMin,
                    double long imagMax, TWinSocketStream *pStream);

    struct InBuffer
    {
     int sx,sy,ex,ey,maxIter;
     double long rMin,rInc,iMin,iInc;
    } ReceiveBuf;







};


#endif
